package com.ejie.ab04b.service;

import java.util.List;

import com.ejie.ab04b.exception.AB04BException;
import com.ejie.ab04b.model.ComunicacionApertura;
import com.ejie.ct.xml.FolderDocumentList;
import com.ejie.foldermanagement.xml.ContextSubmissionEvent;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * ComunicacionApertura generated by UDA, 26-dic-2016 13:08:26.
 * 
 * @author UDA
 */

public interface ComunicacionAperturaService {

	/**
	 * Inserts a single row in the ComunicacionApertura table.
	 * 
	 * comunicApertura ComunicacionApertura ComunicacionApertura
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura add(ComunicacionApertura comunicApertura);

	/**
	 * Updates a single row in the ComunicacionApertura table.
	 * 
	 * comunicApertura ComunicacionApertura ComunicacionApertura
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura update(ComunicacionApertura comunicApertura);

	/**
	 * Updates a single row in the ComunicacionApertura table.
	 * 
	 * comunicApertura ComunicacionApertura ComunicacionApertura
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura updateFilled(ComunicacionApertura comunicApertura);

	/**
	 * Updates a single row in the ComunicacionApertura table.
	 * 
	 * comunicApertura ComunicacionApertura ComunicacionApertura
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura updateCierre(ComunicacionApertura comunicApertura);

	/**
	 * Crea un registro con los datos minimos.
	 * 
	 * ComunicacionApertura
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura altaComunicacionAperturaPresencial(
			ComunicacionApertura comunicApertura);

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 historico the historico Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @param historico
	 *            the historico
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura modificarDatosTabNotificacion(
			ComunicacionApertura ab04b56s00, boolean historico);

	/**
	 * Updates a single row in the ComunicacionApertura table.
	 * 
	 * comunicApertura ComunicacionApertura ComunicacionApertura
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura modificarDatosTabProcAlmac(
			ComunicacionApertura comunicApertura);

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura modificarDatosTabDatosObra(
			ComunicacionApertura ab04b56s00);

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura modificarDatosTabDatosCentro(
			ComunicacionApertura ab04b56s00);

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura modificarDatosTabDatosCentroAsignado(
			ComunicacionApertura ab04b56s00);

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura modificarDatosVisitaOsalan(
			ComunicacionApertura ab04b56s00);

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura modificarDatosTabDatosEmpresa(
			ComunicacionApertura ab04b56s00);

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * apertura ComunicacionApertura ComunicacionApertura
	 * 
	 * @param apertura
	 *            the apertura
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura modificarDatosTabEstadoDoc(
			ComunicacionApertura apertura);

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * apertura ComunicacionApertura ComunicacionApertura
	 * 
	 * @param apertura
	 *            the apertura
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura modificarDatosRegistro(
			ComunicacionApertura apertura);

	/**
	 * Finds a single row in the ComunicacionApertura table.
	 * 
	 * comunicApertura ComunicacionApertura ComunicacionApertura
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura find(ComunicacionApertura comunicApertura);

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura vFind(ComunicacionApertura ab04b56s00);

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura vFindDetalle(ComunicacionApertura ab04b56s00);

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * comunicApertura ComunicacionApertura jqGridRequestDto JQGridRequestDto
	 * filtro ComunicacionApertura Ab04b56s00
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param filtro
	 *            the filtro
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura findDetalle(ComunicacionApertura comunicApertura,
			JQGridRequestDto jqGridRequestDto, ComunicacionApertura filtro);

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * folderId String Ab04b56s00
	 * 
	 * @param folderId
	 *            the folder id
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura findByFolderId(String folderId);

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * folderId String Ab04b56s00
	 * 
	 * @param folderId
	 *            the folder id
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura findByFolderId2(String folderId);

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * comunicApertura ComunicacionApertura Ab04b56s00
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura findComunicAperturaConNotificacion(
			ComunicacionApertura comunicApertura);

	/**
	 * Deletes a single row in the ComunicacionApertura table.
	 * 
	 * comunicApertura ComunicacionApertura
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 */
	void remove(ComunicacionApertura comunicApertura);

	/**
	 * Finds a list of rows in the ComunicacionApertura table.
	 * 
	 * comunicApertura ComunicacionApertura jqGridRequestDto JQGridRequestDto
	 * List<ComunicacionApertura>
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	List<ComunicacionApertura> findAll(ComunicacionApertura comunicApertura,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the ComunicacionApertura table using like.
	 * 
	 * comunicApertura ComunicacionApertura jqGridRequestDto JQGridRequestDto
	 * startsWith Boolean List<ComunicacionApertura>
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	List<ComunicacionApertura> findAllLike(ComunicacionApertura comunicApertura,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the ComunicacionApertura table.
	 * 
	 * filterComunicacionApertura ComunicacionApertura jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean
	 * 
	 * @param filterComunicacionApertura
	 *            the filter comunicacion apertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 */
	void removeMultiple(ComunicacionApertura filterComunicacionApertura,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Filter method in the ComunicacionApertura table.
	 * 
	 * filterComunicacionApertura ComunicacionApertura jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean JQGridResponseDto
	 * <ComunicacionApertura>
	 * 
	 * @param filterComunicacionApertura
	 *            the filter comunicacion apertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<ComunicacionApertura> filter(
			ComunicacionApertura filterComunicacionApertura,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the ComunicacionApertura table.
	 * 
	 * filterComunicacionApertura ComunicacionApertura
	 * searchComunicacionApertura ComunicacionApertura jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto
	 * <ComunicacionApertura>>
	 * 
	 * @param filterComunicacionApertura
	 *            the filter comunicacion apertura
	 * @param searchComunicacionApertura
	 *            the search comunicacion apertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	List<TableRowDto<ComunicacionApertura>> search(
			ComunicacionApertura filterComunicacionApertura,
			ComunicacionApertura searchComunicacionApertura,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Reorder the selection made in ComunicacionApertura table.
	 * 
	 * filterComunicacionApertura ComunicacionApertura jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean Object
	 * 
	 * @param filterComunicacionApertura
	 *            the filter comunicacion apertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the object
	 */
	Object reorderSelection(ComunicacionApertura filterComunicacionApertura,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 ComunicacionApertura Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the list
	 */
	List<ComunicacionApertura> findEmpresaObra(ComunicacionApertura ab04b56s00);

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 ComunicacionApertura Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura findConObra(ComunicacionApertura ab04b56s00);

	/**
	 * Insertar comunicacion apertura context submission.
	 * 
	 * contextSubmission ContextSubmissionEvent ComunicacionApertura
	 * 
	 * @param contextSubmission
	 *            the context submission
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura insertarComunicacionAperturaContextSubmission(
			ContextSubmissionEvent contextSubmission);

	/**
	 * Filter method in the ComunicacionApertura table.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean JQGridResponseDto<ComunicacionApertura>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<ComunicacionApertura> filterListadoAnualMesTer(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * filterListadoAnualMesTerPDF.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto the jq grid request dto
	 * String
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the string
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	String filterListadoAnualMesTerPDF(ComunicacionApertura filtro,
			JQGridRequestDto jqGridRequestDto) throws AB04BException;

	/**
	 * Filter method in the ComunicacionApertura table.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean JQGridResponseDto<ComunicacionApertura>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<ComunicacionApertura> filterListadoBianualMesTer(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Filter method in the ComunicacionApertura table.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean JQGridResponseDto<ComunicacionApertura>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<ComunicacionApertura> filterListadoAnualSecTer(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Filter method in the ComunicacionApertura table.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean JQGridResponseDto<ComunicacionApertura>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<ComunicacionApertura> filterListadoSinInfoOsalan(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * filterListadoSinInfoOsalanPDF.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto the jq grid request dto
	 * String
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the string
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	String filterListadoSinInfoOsalanPDF(ComunicacionApertura filtro,
			JQGridRequestDto jqGridRequestDto) throws AB04BException;

	/**
	 * Filter method in the ComunicacionApertura table.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean JQGridResponseDto<ComunicacionApertura>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<ComunicacionApertura> filterListadoSubsanacion(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Filter method in the ComunicacionApertura table.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto b Boolean
	 * JQGridResponseDto<ComunicacionApertura>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param b
	 *            the b
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<ComunicacionApertura> filterListadoTramosTrabajadores(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			boolean b);

	/**
	 * filterListadoTramosTrabajadoresPDF.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto String
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the string
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	String filterListadoTramosTrabajadoresPDF(ComunicacionApertura filtro,
			JQGridRequestDto jqGridRequestDto) throws AB04BException;

	/**
	 * Filter method in the ComunicacionApertura table.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto b Boolean
	 * JQGridResponseDto<ComunicacionApertura>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param b
	 *            the b
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<ComunicacionApertura> filterlistadoTramosTrabajadoresPorCentro(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			boolean b);

	/**
	 * Filter method in the Ab04b56s00 table.
	 * 
	 * filtro Ab04b56s00 jqGridRequestDto JQGridRequestDto b Boolean
	 * JQGridResponseDto<Ab04b56s00>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param b
	 *            the b
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<ComunicacionApertura> filterListadoTramosTrabajadoresPorTrab(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			boolean b);

	/**
	 * Busca los datos de registro.
	 * 
	 * apertura ComunicacionApertura ComunicacionApertura
	 * 
	 * @param apertura
	 *            the apertura
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura findDatosRegistro(ComunicacionApertura apertura);

	/**
	 * filterListadoAnualSecTerPDF.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto String
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the string
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	String filterListadoAnualSecTerPDF(ComunicacionApertura filtro,
			JQGridRequestDto jqGridRequestDto) throws AB04BException;

	/**
	 * obtenerDocumentosMigrados.
	 * 
	 * folderId String FolderDocumentList
	 * 
	 * @param folderId
	 *            the folder id
	 * @return the folder document list
	 */
	FolderDocumentList obtenerDocumentosMigrados(String folderId);

	/**
	 * filterListadoBianualMesTerPDF.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto String
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the string
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	String filterListadoBianualMesTerPDF(ComunicacionApertura filtro,
			JQGridRequestDto jqGridRequestDto) throws AB04BException;

	/**
	 * filterListadoSubsanacionPDF.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto String
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the string
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	String filterListadoSubsanacionPDF(ComunicacionApertura filtro,
			JQGridRequestDto jqGridRequestDto) throws AB04BException;

	/**
	 * filterListadoTramosTrabajadoresPorCentroPDF.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto String
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the string
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	String filterListadoTramosTrabajadoresPorCentroPDF(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto)
			throws AB04BException;

	/**
	 * filterListadoTramosTrabajadoresPorTrabPDF.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto String
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the string
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	String filterListadoTramosTrabajadoresPorTrabPDF(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto)
			throws AB04BException;

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 updateFecRecInspecc updateFecRecInspecc Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @param updateFecRecInspecc
	 *            the update fec rec inspecc
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura updateFecInspeccion(
			ComunicacionApertura ab04b56s00, boolean updateFecRecInspecc);

	/**
	 * Update cierre temporal.
	 * 
	 * apertura the apertura
	 * 
	 * @param apertura
	 *            the apertura
	 */
	void updateCierreTemporal(ComunicacionApertura apertura);

	/**
	 * Update fec fin plazo.
	 * 
	 * apertura the apertura
	 * 
	 * @param apertura
	 *            the apertura
	 */
	void updateFecFinPlazo(ComunicacionApertura apertura);

	/**
	 * Update usuarios tramitacion.
	 * 
	 * apertura the apertura
	 * 
	 * @param apertura
	 *            the apertura
	 */
	void updateUsuariosTramitacion(ComunicacionApertura apertura);

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * 
	 * filtro ComunicacionApertura ComunicacionApertura
	 * 
	 * @param filtro
	 *            the filtro
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura findLastSSofNumDoc(ComunicacionApertura filtro);

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * 
	 * filtro ComunicacionApertura ComunicacionApertura
	 * 
	 * @param filtro
	 *            the filtro
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura findLastREAofNumDoc(ComunicacionApertura filtro);

	/**
	 * Filter method in the ComunicacionApertura table.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto b Boolean
	 * JQGridResponseDto<ComunicacionApertura>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param b
	 *            the b
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<ComunicacionApertura> filterListadoAperturas(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			boolean b);

	/**
	 * Filter method in the ComunicacionApertura table.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto String
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the string
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	String filterListadoComunicacionAperturasPDF(ComunicacionApertura filtro,
			JQGridRequestDto jqGridRequestDto) throws AB04BException;

	/**
	 * Filter method in the ComunicacionApertura table.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto b Boolean
	 * String
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param b
	 *            the b
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<ComunicacionApertura> filterListadoAperturasNum(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			boolean b);

	/**
	 * Filter method in the ComunicacionApertura table.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto String
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the string
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	String filterListadoComunicacionAperturasNumPDF(ComunicacionApertura filtro,
			JQGridRequestDto jqGridRequestDto) throws AB04BException;

	/**
	 * Valida que el CP pertenezca a la localidad
	 * 
	 * @param comunicacionApertura
	 *            ComunicacionApertura
	 * @return boolean
	 */
	boolean validaLocalidadCP(ComunicacionApertura comunicacionApertura);

	void updateBatchSub(ComunicacionApertura apertura);

	void modificarIndObra(ComunicacionApertura comunicacionApertura);

	void updateFecSub(ComunicacionApertura apertura);

}
